#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;

#endregion



#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		
		private DynamicRSI[] cacheDynamicRSI;
		private DynamicTrendLine[] cacheDynamicTrendLine;
		private FibMA[] cacheFibMA;
		private SRZones[] cacheSRZones;
		private VWAP[] cacheVWAP;

		
		public DynamicRSI DynamicRSI(double dZbuy, double dZsell, int period, int lookback, int smooth)
		{
			return DynamicRSI(Input, dZbuy, dZsell, period, lookback, smooth);
		}

		public DynamicTrendLine DynamicTrendLine(int periodFastMA, int periodSlowMA, int periodStableMA)
		{
			return DynamicTrendLine(Input, periodFastMA, periodSlowMA, periodStableMA);
		}

		public FibMA FibMA()
		{
			return FibMA(Input);
		}

		public SRZones SRZones(int prd, int channelW, int minStrength, int maxNumSR, int loopback, Brush resCol, Brush supCol, Brush inchCol, bool showSRLevels)
		{
			return SRZones(Input, prd, channelW, minStrength, maxNumSR, loopback, resCol, supCol, inchCol, showSRLevels);
		}

		public VWAP VWAP()
		{
			return VWAP(Input);
		}


		
		public DynamicRSI DynamicRSI(ISeries<double> input, double dZbuy, double dZsell, int period, int lookback, int smooth)
		{
			if (cacheDynamicRSI != null)
				for (int idx = 0; idx < cacheDynamicRSI.Length; idx++)
					if (cacheDynamicRSI[idx].DZbuy == dZbuy && cacheDynamicRSI[idx].DZsell == dZsell && cacheDynamicRSI[idx].Period == period && cacheDynamicRSI[idx].Lookback == lookback && cacheDynamicRSI[idx].Smooth == smooth && cacheDynamicRSI[idx].EqualsInput(input))
						return cacheDynamicRSI[idx];
			return CacheIndicator<DynamicRSI>(new DynamicRSI(){ DZbuy = dZbuy, DZsell = dZsell, Period = period, Lookback = lookback, Smooth = smooth }, input, ref cacheDynamicRSI);
		}

		public DynamicTrendLine DynamicTrendLine(ISeries<double> input, int periodFastMA, int periodSlowMA, int periodStableMA)
		{
			if (cacheDynamicTrendLine != null)
				for (int idx = 0; idx < cacheDynamicTrendLine.Length; idx++)
					if (cacheDynamicTrendLine[idx].PeriodFastMA == periodFastMA && cacheDynamicTrendLine[idx].PeriodSlowMA == periodSlowMA && cacheDynamicTrendLine[idx].PeriodStableMA == periodStableMA && cacheDynamicTrendLine[idx].EqualsInput(input))
						return cacheDynamicTrendLine[idx];
			return CacheIndicator<DynamicTrendLine>(new DynamicTrendLine(){ PeriodFastMA = periodFastMA, PeriodSlowMA = periodSlowMA, PeriodStableMA = periodStableMA }, input, ref cacheDynamicTrendLine);
		}

		public FibMA FibMA(ISeries<double> input)
		{
			if (cacheFibMA != null)
				for (int idx = 0; idx < cacheFibMA.Length; idx++)
					if ( cacheFibMA[idx].EqualsInput(input))
						return cacheFibMA[idx];
			return CacheIndicator<FibMA>(new FibMA(), input, ref cacheFibMA);
		}

		public SRZones SRZones(ISeries<double> input, int prd, int channelW, int minStrength, int maxNumSR, int loopback, Brush resCol, Brush supCol, Brush inchCol, bool showSRLevels)
		{
			if (cacheSRZones != null)
				for (int idx = 0; idx < cacheSRZones.Length; idx++)
					if (cacheSRZones[idx].Prd == prd && cacheSRZones[idx].ChannelW == channelW && cacheSRZones[idx].MinStrength == minStrength && cacheSRZones[idx].MaxNumSR == maxNumSR && cacheSRZones[idx].Loopback == loopback && cacheSRZones[idx].ResCol == resCol && cacheSRZones[idx].SupCol == supCol && cacheSRZones[idx].InchCol == inchCol && cacheSRZones[idx].ShowSRLevels == showSRLevels && cacheSRZones[idx].EqualsInput(input))
						return cacheSRZones[idx];
			return CacheIndicator<SRZones>(new SRZones(){ Prd = prd, ChannelW = channelW, MinStrength = minStrength, MaxNumSR = maxNumSR, Loopback = loopback, ResCol = resCol, SupCol = supCol, InchCol = inchCol, ShowSRLevels = showSRLevels }, input, ref cacheSRZones);
		}

		public VWAP VWAP(ISeries<double> input)
		{
			if (cacheVWAP != null)
				for (int idx = 0; idx < cacheVWAP.Length; idx++)
					if ( cacheVWAP[idx].EqualsInput(input))
						return cacheVWAP[idx];
			return CacheIndicator<VWAP>(new VWAP(), input, ref cacheVWAP);
		}

	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		
		public Indicators.DynamicRSI DynamicRSI(double dZbuy, double dZsell, int period, int lookback, int smooth)
		{
			return indicator.DynamicRSI(Input, dZbuy, dZsell, period, lookback, smooth);
		}

		public Indicators.DynamicTrendLine DynamicTrendLine(int periodFastMA, int periodSlowMA, int periodStableMA)
		{
			return indicator.DynamicTrendLine(Input, periodFastMA, periodSlowMA, periodStableMA);
		}

		public Indicators.FibMA FibMA()
		{
			return indicator.FibMA(Input);
		}

		public Indicators.SRZones SRZones(int prd, int channelW, int minStrength, int maxNumSR, int loopback, Brush resCol, Brush supCol, Brush inchCol, bool showSRLevels)
		{
			return indicator.SRZones(Input, prd, channelW, minStrength, maxNumSR, loopback, resCol, supCol, inchCol, showSRLevels);
		}

		public Indicators.VWAP VWAP()
		{
			return indicator.VWAP(Input);
		}


		
		public Indicators.DynamicRSI DynamicRSI(ISeries<double> input , double dZbuy, double dZsell, int period, int lookback, int smooth)
		{
			return indicator.DynamicRSI(input, dZbuy, dZsell, period, lookback, smooth);
		}

		public Indicators.DynamicTrendLine DynamicTrendLine(ISeries<double> input , int periodFastMA, int periodSlowMA, int periodStableMA)
		{
			return indicator.DynamicTrendLine(input, periodFastMA, periodSlowMA, periodStableMA);
		}

		public Indicators.FibMA FibMA(ISeries<double> input )
		{
			return indicator.FibMA(input);
		}

		public Indicators.SRZones SRZones(ISeries<double> input , int prd, int channelW, int minStrength, int maxNumSR, int loopback, Brush resCol, Brush supCol, Brush inchCol, bool showSRLevels)
		{
			return indicator.SRZones(input, prd, channelW, minStrength, maxNumSR, loopback, resCol, supCol, inchCol, showSRLevels);
		}

		public Indicators.VWAP VWAP(ISeries<double> input )
		{
			return indicator.VWAP(input);
		}
	
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		
		public Indicators.DynamicRSI DynamicRSI(double dZbuy, double dZsell, int period, int lookback, int smooth)
		{
			return indicator.DynamicRSI(Input, dZbuy, dZsell, period, lookback, smooth);
		}

		public Indicators.DynamicTrendLine DynamicTrendLine(int periodFastMA, int periodSlowMA, int periodStableMA)
		{
			return indicator.DynamicTrendLine(Input, periodFastMA, periodSlowMA, periodStableMA);
		}

		public Indicators.FibMA FibMA()
		{
			return indicator.FibMA(Input);
		}

		public Indicators.SRZones SRZones(int prd, int channelW, int minStrength, int maxNumSR, int loopback, Brush resCol, Brush supCol, Brush inchCol, bool showSRLevels)
		{
			return indicator.SRZones(Input, prd, channelW, minStrength, maxNumSR, loopback, resCol, supCol, inchCol, showSRLevels);
		}

		public Indicators.VWAP VWAP()
		{
			return indicator.VWAP(Input);
		}


		
		public Indicators.DynamicRSI DynamicRSI(ISeries<double> input , double dZbuy, double dZsell, int period, int lookback, int smooth)
		{
			return indicator.DynamicRSI(input, dZbuy, dZsell, period, lookback, smooth);
		}

		public Indicators.DynamicTrendLine DynamicTrendLine(ISeries<double> input , int periodFastMA, int periodSlowMA, int periodStableMA)
		{
			return indicator.DynamicTrendLine(input, periodFastMA, periodSlowMA, periodStableMA);
		}

		public Indicators.FibMA FibMA(ISeries<double> input )
		{
			return indicator.FibMA(input);
		}

		public Indicators.SRZones SRZones(ISeries<double> input , int prd, int channelW, int minStrength, int maxNumSR, int loopback, Brush resCol, Brush supCol, Brush inchCol, bool showSRLevels)
		{
			return indicator.SRZones(input, prd, channelW, minStrength, maxNumSR, loopback, resCol, supCol, inchCol, showSRLevels);
		}

		public Indicators.VWAP VWAP(ISeries<double> input )
		{
			return indicator.VWAP(input);
		}

	}
}

#endregion
